/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.util;

import com.ibm.hwmca.base.pa.ar.XMLHelper;
import com.ibm.hwmca.base.pa.util.GenericNonValidatingParser;
import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.fw.XMLEncodeable;
import com.ibm.hwmca.fw.pa.ConfigFileFilter;
import com.ibm.hwmca.fw.pa.persist.DefaultProblemPersistence;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.pa.problem.CommonProblem;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ProblemFromXML {
    private static final String TRACE_MASKT = "XPALXMLT";
    private static final String TRACE_MASKF = "XPALXMLF";
    private static final String TRACE_MASKD = "XPALXMLD";
    private static final String problemTag = "problems";
    private static String CONFIG_FILE_PREFIX = "config_";
    private static String CONFIG_FILE_SUFFIX = ".xml";
    public static int SUCCESS = 0;
    public static int PARSE_ERROR = 100;
    public static int STORE_ERROR = 200;
    public static final String xmlProblemsFile = "problems.xml";
    private String baseFilePath = null;

    public static int main(String[] args) {
        String baseFilePath = ProblemFromXML.getBaseFilePath();
        for (int i = 0; i < args.length; ++i) {
            System.out.println(args[i]);
        }
        ArrayList pNodes = ProblemFromXML.getPersistNodes(baseFilePath);
        String path = null;
        String tag = null;
        if (args.length > 1) {
            System.out.println(args[0]);
            System.out.println(args[1]);
            path = args[0];
            tag = args[1];
        } else {
            System.out.println(" baseFilePath =" + baseFilePath);
            System.out.println(baseFilePath + xmlProblemsFile);
            path = baseFilePath + xmlProblemsFile;
            tag = problemTag;
        }
        ArrayList problemList = ProblemFromXML.getProblems(path);
        if (problemList.size() <= 0) {
            return PARSE_ERROR;
        }
        if (ProblemFromXML.storeProblems(problemList, pNodes) != 0) {
            return STORE_ERROR;
        }
        System.out.println("EXIT STAGE LEFT");
        return SUCCESS;
    }

    public static int convertProblems(String path) {
        String baseFilePath = ProblemFromXML.getBaseFilePath();
        ArrayList pNodes = ProblemFromXML.getPersistNodes(baseFilePath);
        ArrayList problemList = ProblemFromXML.getProblems(path);
        if (problemList.size() <= 0) {
            return PARSE_ERROR;
        }
        return ProblemFromXML.storeProblems(problemList, pNodes);
    }

    public static String getBaseFilePath() {
        try {
            return BaseFileControl.getFilePath("paconfig");
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static ArrayList getPersistNodes(String baseFilePath) {
        File[] configFiles = new File(baseFilePath).listFiles(new ConfigFileFilter());
        GenericNonValidatingParser myParser = null;
        try {
            myParser = new GenericNonValidatingParser();
        }
        catch (Exception e) {
            e.printStackTrace();
            Trace.trace(TRACE_MASKT, "Error getting baseFilePath Processing config file");
        }
        ArrayList<NodeList> persistentNodeLists = new ArrayList<NodeList>();
        for (int i = 0; i < configFiles.length; ++i) {
            try {
                Trace.trace(TRACE_MASKD, "Processing config file '" + configFiles[i].getCanonicalPath() + "'.");
            }
            catch (IOException e) {
                Trace.trace(TRACE_MASKD, "Processing config file '" + configFiles[i] + "ProblemFromXml.parseXML");
            }
            try {
                System.out.println(" configFile = " + configFiles[i]);
                NodeList persistence = GenericNonValidatingParser.parseXML(configFiles[i], "persistence");
                persistentNodeLists.add(persistence);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        System.out.println("Done with config file parsing");
        return persistentNodeLists;
    }

    public static ArrayList getProblems(String pathNFile) {
        GenericNonValidatingParser myParser = null;
        NodeList problemsNode = null;
        try {
            myParser = new GenericNonValidatingParser();
            problemsNode = GenericNonValidatingParser.parseXMLFileNameForTag(pathNFile, problemTag);
        }
        catch (Exception e) {
            System.out.println("we have had a problem here");
            e.printStackTrace();
        }
        NodeList problems2create = null;
        ArrayList<XMLEncodeable> problemList = new ArrayList<XMLEncodeable>();
        if (problemsNode != null) {
            if (problemsNode.getLength() > 1) {
                System.out.println("We have a problem with the number of problem nodes in this file");
                return problemList;
            }
            problems2create = problemsNode.item(0).getChildNodes();
            Object path = null;
            for (int i = 0; i < problems2create.getLength(); ++i) {
                if (!problems2create.item(i).hasAttributes() || XMLHelper.getAttributeValue(problems2create.item(i), "class") == null) continue;
                try {
                    Class<?> thisClass = Class.forName(XMLHelper.getAttributeValue(problems2create.item(i), "class").substring(1));
                    Class[] parms = new Class[]{};
                    Constructor<?> cons = thisClass.getConstructor(parms);
                    cons.setAccessible(true);
                    Object[] objs = new Object[]{};
                    Object thisObj = cons.newInstance(objs);
                    if (!(thisObj instanceof XMLEncodeable)) continue;
                    XMLEncodeable tempObj = (XMLEncodeable)thisObj;
                    tempObj.fromXML(problems2create.item(i));
                    problemList.add(tempObj);
                    continue;
                }
                catch (Exception e) {
                    System.out.println("we have had a problem parsing and creating");
                    e.printStackTrace();
                }
            }
        }
        return problemList;
    }

    public static int storeProblems(ArrayList problemList, ArrayList persistentNodeLists) {
        for (int i = 0; i < problemList.size(); ++i) {
            Object thisProblem = problemList.get(i);
            for (int y = 0; y < persistentNodeLists.size(); ++y) {
                NodeList persistenceNode = (NodeList)persistentNodeLists.get(y);
                for (int z = 0; z < persistenceNode.getLength(); ++z) {
                    Node problemManagerNode = XMLHelper.getWorkSection(persistenceNode.item(0), "problem-manager");
                    try {
                        Node persistenceImpl;
                        String subClass;
                        Class<?> subClassClass;
                        Object implObject;
                        if (problemManagerNode == null || !(implObject = (subClassClass = Class.forName(subClass = XMLHelper.getAttributeValue(problemManagerNode, "subclass"))).newInstance()).getClass().isAssignableFrom(thisProblem.getClass()) || (persistenceImpl = XMLHelper.getWorkSection(problemManagerNode, "class")) == null) continue;
                        Class<?> myImpl = Class.forName(XMLHelper.getRealValue(persistenceImpl));
                        DefaultProblemPersistence thisImpl = (DefaultProblemPersistence)myImpl.newInstance();
                        thisImpl.store((CommonProblem)thisProblem);
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return STORE_ERROR;
                    }
                }
            }
        }
        return SUCCESS;
    }
}

